package com.qboxus.tictic.activitesfragments

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.activity.result.contract.ActivityResultContracts.StartActivityForResult
import androidx.databinding.DataBindingUtil
import androidx.recyclerview.widget.LinearLayoutManager
import com.qboxus.tictic.R
import com.qboxus.tictic.activitesfragments.chat.ChatActivity
import com.qboxus.tictic.adapters.InboxAdapter
import com.qboxus.tictic.databinding.ActivityInboxBinding
import com.qboxus.tictic.interfaces.ChatAdapterClickListener
import com.qboxus.tictic.interfaces.FirebaseChatCallback
import com.qboxus.tictic.models.InboxModel
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.DebounceClickHandler
import com.qboxus.tictic.simpleclasses.DelayedTextWatcher
import com.qboxus.tictic.simpleclasses.FirebaseChatUtil
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError

class InboxActivity : AppCompatLocaleActivity() {

    var inboxArraylist: ArrayList<InboxModel> = ArrayList()
    var searchlist: ArrayList<InboxModel> = ArrayList()
    var inboxAdapter: InboxAdapter? = null
    lateinit var binding: ActivityInboxBinding
    var isActivityCallback = false

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        Functions.setLocale(Functions.getSharedPreference(this).getString(Variables.APP_LANGUAGE_CODE,
            Variables.DEFAULT_LANGUAGE_CODE), this, javaClass, false)
        binding = DataBindingUtil.setContentView(this,R.layout.activity_inbox)
        initControl()
        actionControl()
    }

    private fun actionControl() {
        binding.backBtn.setOnClickListener(DebounceClickHandler{
            onBackPressed()
        })
        binding.etSearch.addTextChangedListener(
            DelayedTextWatcher(delayMillis = 500) { text ->
               if (text.isEmpty())
               {
                   applyAdapterFilter("${text}")
                   binding.tvSearch.visibility = View.GONE
               } else
               {
                   binding.tvSearch.visibility = View.VISIBLE
               }
            }
        )
        binding.tvSearch.setOnClickListener(DebounceClickHandler{
            Functions.hideKeyboard(binding.etSearch)
            binding.etSearch.clearFocus()
            applyAdapterFilter("${binding.etSearch.text}")
        })
    }

    private fun applyAdapterFilter(words: String) {
        val word=words.lowercase()
        if (word.isNotEmpty())
        {
            val filterList:ArrayList<InboxModel> = ArrayList()
            for(item in searchlist)
            {
                if ((item.name.lowercase()).contains(word) || (item.msg.lowercase()).contains(word))
                {
                    filterList.add(item)
                }
            }
            inboxAdapter?.filter(filterList)
        } else
        {
            inboxArraylist.clear()
            inboxArraylist.addAll(searchlist)
        }
        updateNoDataView()
    }

    private fun initControl() {
        setupAdapter()

        FirebaseChatUtil.registerUserInbox(binding.root.context,object: FirebaseChatCallback {
            override fun onDataChange(dataSnapshot: DataSnapshot) {
                inboxArraylist.clear()
                searchlist.clear()
                for (ds in dataSnapshot.children) {
                    val model = ds.getValue(InboxModel::class.java)
                    model!!.id = ds.key
                    inboxArraylist.add(model)
                    searchlist.add(model)
                }
                updateNoDataView()
            }
            override fun onCancelled(databaseError: DatabaseError) {
                updateNoDataView()
            }
        })
    }

    private fun updateNoDataView() {
        binding.pbar.visibility = View.GONE
        if (inboxArraylist.isEmpty()) {
            binding.noDataLayout.visibility = View.VISIBLE
        } else {
            binding.noDataLayout.visibility = View.GONE
        }
        inboxAdapter?.notifyDataSetChanged()
    }

    private fun setupAdapter() {
        val layout = LinearLayoutManager(binding.root.context)
        layout.orientation = LinearLayoutManager.VERTICAL
        binding.inboxlist.layoutManager = layout
        binding.inboxlist.setHasFixedSize(false)
        inboxAdapter = InboxAdapter(inboxArraylist,object: ChatAdapterClickListener{
            override fun onItemClick(view: View, position: Int) {
                val item = inboxArraylist.get(position)
                chatFragment(item.id, item.name, item.pic)
            }

            override fun onItemLongClick(view: View, position: Int) {
                val item = inboxArraylist.get(position)
            }
        })
        binding.inboxlist.adapter = inboxAdapter
    }



    var resultCallback = registerForActivityResult(
        StartActivityForResult()
    ) { result ->
        if (result.resultCode == RESULT_OK) {
            result.data?.let {data->
                if (data.getBooleanExtra("isShow", false)) {

                }
            }
        }
    }
    fun chatFragment(receiverid: String?, name: String?, picture: String?) {
        isActivityCallback = true
        val intent = Intent(this@InboxActivity, ChatActivity::class.java)
        intent.putExtra("user_id", receiverid)
        intent.putExtra("user_name", name)
        intent.putExtra("user_pic", picture)
        try {
            resultCallback.launch(intent)
        }catch (e:Exception){
            startActivity(intent)
        }
        overridePendingTransition(R.anim.in_from_right, R.anim.out_to_left)
    }

    override fun onBackPressed() {
        if (isActivityCallback) {
            val intent = Intent()
            intent.putExtra("isShow", true)
            setResult(RESULT_OK, intent)
        }
        finish()
    }

    override fun onResume() {
        super.onResume()
       updateNoDataView()
    }

    override fun onDestroy() {
        FirebaseChatUtil.unregisterUserInbox()
        super.onDestroy()
    }
}
